<CsoundSynthesizer>
<CsOptions>
</CsOptions>
<CsInstruments>
sr        =         44100
kr        =         4410
ksmps     =         10
nchnls    =         2

          instr 6
          
; SHIMMERING INSTR #1
; VARIABLE #PARTIALS, POWER TO PARTIALS, STARTING PARTIAL, ETC
; P4=PCH P5=AMP P6=POWER P7=CHNL1AMP
                                             
i1        =          cpsoct(p4-2)
k1        linseg     0,p3/2,p5,p3/2,0        ; ENV
k2        randi      2,25
k3        oscil      .03,4+k2,1              ; RAND TREM
a1        gbuzz      .33+k3,i1,p6,1,50,4
k4        randi      1.2,15
k5        oscil      .03,4+k2,1              ; RAND TREM
a2        gbuzz      .33+k5,i1+(i1*.02),p6,1,50,4
k6        randi      1.5,20
k7        oscil      .03,4+k2,1              ; RAND TREM
a3        gbuzz      .33+k7,i1-(i1*.021),p6,1,50,4
a4        =          (a1+a2+a3)*k1
ga1       =          a4*p7
ga2       =          a4*(1-p7)
          outs       ga1,ga2
          endin

          instr 7   
; FINGER CYMBALS WHEN HIGH F, LOWER PITCHES INTERESTING TOO
; P4=PCH P5=AMP P6=CHNL1AMP

i1        =          cpsoct(p4)
k1        expseg     .0001,.05,p5,p3-.05,.0001       ; ENV
k2        linseg     1.69,.1,1.75,p3-.1,1.69         ; POWER TO PARTIALS
a1        foscil     k1,i1,1,2.01,k2,1
ga1       =          a1*p6
ga2       =          a1*(1-p6)
          outs       ga1,ga2
          endin

          instr 10,11,12,13,14,15       
          
; SIMPLE MARIMBA
; P4=PCH P5=AMP P6=BIAS

i1        =          cpsoct(p4)
i2        =         log(i1)/10.0 - p6
k1        expseg     .0001,.03,p5,p3-.03,.001      ; ENV
k25       linseg     1,.03,1,p3-.03,3
k1        =          k25*k1
k10       linseg     2.25,.03,3,p3-.03,2           ; POWER TO PARTIALS
a1        gbuzz      k1,i1,k10,0,35,4
a2        reson      a1,500,50,1     ;filt
a3        reson      a2,1500,100,1   ;filt
a4        reson      a3,2500,150,1   ;filt
a5        reson      a4,3500,150,1   ;filt
a6        balance    a5,a1
i6        =          p6
ga7       =         a6*i2
ga8       =         a6*(1-i2)
;;        display   a6, 0.25
          outs      ga7,ga8
;;        out       a6
          endin

</CsInstruments>
<CsScore>
f1  0 513 10 1                                    ; sine
f3  0 513 10 3 1 0 .25 .3 .76
f4  0 513 9  1 1 90                               ; cosine
f5  0 513 10 1 .2 0 .06 0 .4                 ;altered sine
f8  0 256 7  0 0 1 128 1 0 -1 128 -1         ;square
f31 0 513 13 1 1 .9 .8 .7 .6 .5 .4 .3 .2 .1 ;gen 13 table lookup
f32 0 513 13 1 1 .9 .8 .7 .6 .7 .8 .9 1     ;gen 13 table lookup

t 0 220 400 240 800 256 1200 300
i7  1.000   10.652  9.67    7000    0.37
i7  1.652   10.895  9.74    7000    0.37
i7  2.547   10.591  9.77    7000    0.37
i7  3.138   10.389  9.79    7000    0.37
i7  3.527   10.347  9.60    7000    0.37
i7  3.874   10.436  9.63    7000    0.37
i7  4.310   10.700  9.68    7000    0.37
i10 1   20  7.70    9000    0.15
i11 1   20  10.10   8000    0.15
i12 4   20  6.74    8000    0.15
i13 4   20  10.28   8200    0.15
i14 20  7   5.92    8000    0.15
i15 20  7   9.03    8000    0.15
i10 11  20  8.53    8600    0.15
i11 12  20  10.09   8000    0.15
i12 14  20  7.01    8000    0.15
i13 15  20  10.54   8000    0.15
i14 17  20  5.19    8200    0.15
i15 20  20  7.27    8000    0.15
i10 20  20  9.24    9000    0.15
i11 21  20  8.59    8000    0.15
i12 22  20  10.10   8000    0.15
i13 25  20  6.99    8200    0.15
i14 25  20  10.53   8000    0.15
i15 29  20  5.21    8000    0.15
i10 32  20  7.34    8600    0.15
i11 32  20  9.28    8000    0.15
i12 33  20  8.54    8000    0.15
i13 34  20  10.16   8000    0.15
i14 37  20  6.81    8200    0.15
i15 37  20  10.38   8000    0.15
i10 40  20  5.64    9000    0.15
i11 42  20  8.44    8000    0.15
i12 42  20  9.16    8000    0.15
i13 43  20  9.07    8000    0.15
i14 44  20  9.44    8200    0.15
i15 46  20  8.75    8000    0.15
i10 47  20  9.99    8000    0.15
i11 49  20  7.37    8600    0.15
i12 49  20  10.72   8000    0.15
i13 52  20  4.68    8000    0.15
i7  54.000  11.462  11.31   7000    0.62
i7  55.462  11.300  11.13   7000    0.62
i7  56.762  11.325  11.15   7000    0.62
i7  57.088  11.548  11.19   7000    0.62
i7  58.636  11.816  11.26   7000    0.62
i7  59.452  11.512  11.30   7000    0.62
i7  60.964  11.324  11.13   7000    0.62
i14 56  20  5.67    8200    0.15
i15 58  20  6.80    8000    0.15
i10 59  20  9.01    8000    0.15
i11 60  20  8.82    9000    0.15
i12 61  20  9.76    8000    0.15
i13 63  20  7.95    8000    0.15
i14 63  20  10.68   8000    0.15
i15 66  20  4.99    8200    0.15
i7  68.000  10.661  9.82    7000    0.21
i7  68.661  10.906  9.89    7000    0.21
i7  69.567  10.590  9.93    7000    0.21
i7  70.157  10.432  9.75    7000    0.21
i7  70.589  10.508  9.78    7000    0.21
i7  71.097  10.812  9.85    7000    0.21
i7  71.909  10.800  9.91    7000    0.21
i10 71  20  6.72    8000    0.15
i11 71  20  8.72    8600    0.15
i12 71  20  9.19    8000    0.15
i13 72  20  9.11    8000    0.15
i14 73  20  9.39    8000    0.15
i15 75  20  8.85    8200    0.15
i10 76  20  9.83    8000    0.15
i11 78  20  7.80    8000    0.15
i12 78  20  10.73   8000    0.15
i13 81  20  4.76    9000    0.15
i7  83.000  11.679  9.98    7000    0.51
i7  84.679  11.835  10.02   7000    0.51
i7  86.515  12.154  10.09   7000    0.51
i7  88.668  11.919  10.14   7000    0.51
i7  90.587  11.679  10.16   7000    0.51
i7  92.266  11.646  9.98    7000    0.51
i7  93.913  11.809  10.02   7000    0.51
i14 84  20  5.96    8000    0.15
i15 86  20  7.46    8200    0.15
i10 86  20  9.54    8000    0.15
i11 86  20  8.04    8000    0.15
i12 88  20  10.58   8000    0.15
i13 91  20  5.35    8600    0.15
i14 93  20  7.74    8000    0.15
i15 93  20  9.39    8000    0.15
i10 95  20  8.44    8200    0.15
i11 96  20  10.29   8000    0.15
i12 98  20  6.41    8000    0.15
i13 99  20  9.91    9000    0.15
i14 101 20  6.87    8000    0.15
i15 102 20  10.36   8000    0.15
i10 105 20  5.72    8200    0.15
i11 107 20  8.62    8000    0.15
i12 108 20  9.01    8000    0.15
i13 109 20  9.37    8600    0.15
i14 111 20  8.87    8000    0.15
i15 112 20  9.81    8000    0.15
i10 114 20  7.86    8200    0.15
i11 114 20  10.72   8000    0.15
e
i12 118 20  4.84    8000    0.15
i7  120.000 11.395  11.33   7000    0.47
i7  121.395 11.133  11.35   7000    0.47
i7  122.528 11.050  11.16   7000    0.47
i7  123.578 11.104  11.18   7000    0.47
i7  124.681 11.327  11.22   7000    0.47
i7  126.009 11.614  11.29   7000    0.47
i7  126.623 11.323  11.33   7000    0.47
i13 120 20  6.22    9000    0.15
i14 121 20  7.97    8000    0.15
i15 121 20  9.62    8000    0.15
i10 123 20  8.04    8200    0.15
i11 123 20  10.61   8000    0.15
i12 126 20  5.27    8000    0.15
i13 129 20  7.53    8600    0.15
i14 129 20  9.35    8000    0.15
i15 131 20  8.45    8000    0.15
i10 131 20  10.27   8000    0.15
i11 134 20  6.48    8200    0.15
i12 135 20  10.01   8000    0.15
i13 137 20  6.63    8000    0.15
i14 137 20  10.12   9000    0.15
i15 141 20  6.35    8000    0.15
i10 142 20  9.76    8000    0.15
i11 144 20  7.21    8200    0.15
i12 144 20  10.58   8000    0.15
i13 147 20  5.12    8000    0.15
i14 150 20  7.08    8600    0.15
i15 150 20  9.10    8000    0.15
i10 151 20  8.77    8000    0.15
i11 152 20  9.85    8200    0.15
i12 154 20  7.73    8000    0.15
i13 154 20  10.74   8000    0.15
i14 155 20  4.70    9000    0.15
i7  159.000 11.597  9.60    7000    0.20
i7  160.597 11.683  9.62    7000    0.20
i7  162.280 11.950  9.67    7000    0.20
i7  164.231 12.147  9.74    7000    0.20
i7  166.378 11.821  9.77    7000    0.20
i7  168.200 11.663  9.59    7000    0.20
i7  169.863 11.704  9.62    7000    0.20
i15 160 20  5.77    8000    0.15
i10 162 20  7.03    8000    0.15
i11 162 20  9.26    8200    0.15
i12 163 20  8.49    8000    0.15
i13 163 20  10.21   8000    0.15
i14 166 20  6.67    8000    0.15
i15 166 20  10.24   8600    0.15
i10 169 20  6.04    8000    0.15
i11 172 20  9.25    8200    0.15
i12 173 20  8.20    8000    0.15
i13 173 20  10.42   8000    0.15
e
i14 176 20  5.94    8000    0.15
i15 178 20  9.10    9000    0.15
i10 179 20  8.42    8000    0.15
i11 179 20  10.22   8000    0.15
i12 182 20  6.62    8200    0.15
i13 183 20  10.18   8000    0.15
i14 186 20  6.20    8000    0.15
i15 187 20  9.53    8600    0.15
i10 187 20  7.69    8000    0.15
i11 189 20  10.65   8000    0.15
i12 192 20  5.02    8200    0.15
i13 195 20  6.80    8000    0.15
i14 196 20  8.83    8000    0.15
i15 197 20  9.09    9000    0.15
i10 198 20  9.31    8000    0.15
i11 200 20  9.00    8000    0.15
i12 201 20  9.60    8200    0.15
i13 203 20  8.39    8000    0.15
i14 203 20  10.40   8000    0.15
i15 206 20  6.07    8600    0.15
i10 208 20  9.35    8000    0.15
i11 209 20  8.02    8000    0.15
i12 210 20  10.54   8000    0.15
i13 213 20  5.50    8200    0.15
i14 215 20  8.12    8000    0.15
i15 215 20  9.34    8000    0.15
i10 217 20  8.66    9000    0.15
i11 218 20  10.05   8000    0.15
i12 220 20  7.17    8000    0.15
i13 220 20  10.64   8200    0.15
i14 223 20  4.89    8000    0.15
i7  224.000 11.293  10.71   7000    0.42
i7  225.293 10.963  10.75   7000    0.42
i7  226.256 10.828  10.57   7000    0.42
i7  227.084 10.940  10.61   7000    0.42
i7  228.024 11.268  10.68   7000    0.42
i7  229.292 11.119  10.73   7000    0.42
i7  230.410 10.842  10.76   7000    0.42
i15 226 20  6.38    8600    0.15
i10 227 20  8.24    8000    0.15
i11 227 20  9.53    8000    0.15
i12 229 20  8.30    8000    0.15
i13 229 20  10.44   8000    0.15
i14 232 20  5.90    8200    0.15
i15 234 20  9.04    8000    0.15
i10 235 20  8.51    9000    0.15
i11 236 20  10.12   8000    0.15
i12 239 20  6.93    8000    0.15
i13 239 20  10.48   8000    0.15
i14 242 20  5.35    8200    0.15
i15 244 20  7.72    8000    0.15
i10 244 20  9.40    8000    0.15
i11 246 20  8.43    8600    0.15
i12 246 20  10.30   8000    0.15
i13 249 20  6.38    8000    0.15
i14 250 20  9.86    8200    0.15
i15 252 20  6.97    8000    0.15
i10 253 20  10.44   8000    0.15
i11 255 20  5.50    9000    0.15
i12 257 20  8.10    8000    0.15
i13 257 20  9.35    8000    0.15
i14 259 20  8.64    8200    0.15
i15 260 20  10.08   8000    0.15
i10 262 20  7.07    8000    0.15
i11 262 20  10.58   8000    0.15
i12 265 20  5.07    8600    0.15
i13 268 20  6.92    8000    0.15
i14 268 20  8.96    8000    0.15
i15 269 20  8.94    8200    0.15
i10 270 20  9.58    8000    0.15
i11 272 20  8.42    8000    0.15
i12 272 20  10.36   8000    0.15
i13 275 20  6.18    9000    0.15
i14 276 20  9.56    8000    0.15
i15 278 20  7.63    8200    0.15
i10 278 20  10.65   8000    0.15
i11 281 20  4.99    8000    0.15
i7  283.000 10.444  9.67    7000    0.46
i7  283.444 10.776  9.74    7000    0.46
i7  284.220 10.625  9.79    7000    0.46
i7  284.845 10.338  9.81    7000    0.46
i7  285.183 10.239  9.62    7000    0.46
i7  285.422 10.279  9.64    7000    0.46
i7  285.701 10.485  9.68    7000    0.46
i12 284 20  6.69    8600    0.15
i13 285 20  8.69    8000    0.15
i14 286 20  9.22    8000    0.15
i15 287 20  9.04    8000    0.15
i10 288 20  9.51    8200    0.15
i11 290 20  8.59    8000    0.15
i12 291 20  10.18   8000    0.15
i13 294 20  6.79    9000    0.15
i14 295 20  10.36   8000    0.15
i15 298 20  5.70    8200    0.15
i10 300 20  8.56    8000    0.15
i11 301 20  9.07    8000    0.15
i12 302 20  9.26    8000    0.15
i13 303 20  9.09    8600    0.15
i14 305 20  9.45    8000    0.15
i15 306 20  8.73    8000    0.15
i10 307 20  10.00   8200    0.15
i11 309 20  7.33    8000    0.15
i12 309 20  10.71   8000    0.15
i13 312 20  4.71    9000    0.15
i7  314.000 11.404  11.37   7000    0.04
i7  315.404 11.152  11.39   7000    0.04
i7  316.557 11.058  11.40   7000    0.04
i7  317.615 11.055  11.21   7000    0.04
i7  318.670 11.141  11.23   7000    0.04
i7  319.811 11.379  11.27   7000    0.04
i7  321.191 11.672  11.34   7000    0.04
i14 315 20  5.78    8000    0.15
i15 317 20  7.06    8000    0.15
i10 318 20  9.28    8200    0.15
i11 318 20  8.44    8000    0.15
i12 318 20  10.25   8000    0.15
i13 321 20  6.53    8000    0.15
i14 322 20  10.06   8600    0.15
i15 324 20  6.50    8000    0.15
i10 325 20  9.97    8000    0.15
i11 327 20  6.75    8200    0.15
i12 328 20  10.25   8000    0.15
i13 331 20  6.02    8000    0.15
i14 332 20  9.23    9000    0.15
i15 334 20  8.24    8000    0.15
i10 335 20  10.39   8000    0.15
i11 337 20  6.05    8200    0.15
i12 339 20  9.32    8000    0.15
i13 341 20  8.08    8000    0.15
i14 341 20  10.50   8600    0.15
i15 344 20  5.63    8000    0.15
i10 346 20  8.45    8000    0.15
i11 346 20  9.15    8200    0.15
i12 347 20  9.09    8000    0.15
i13 348 20  9.40    8000    0.15
i14 350 20  8.83    8000    0.15
i15 351 20  9.87    9000    0.15
i10 353 20  7.69    8000    0.15
i11 353 20  10.75   8000    0.15
i12 356 20  4.66    8200    0.15
i7  358.000 11.482  10.43   7000    0.86
i7  359.482 11.399  10.24   7000    0.86
i7  360.881 11.401  10.25   7000    0.86
i7  362.282 11.490  10.27   7000    0.86
i7  363.772 11.732  10.31   7000    0.86
i7  365.504 12.023  10.38   7000    0.86
i7  367.527 11.712  10.42   7000    0.86
i13 359 20  5.64    8000    0.15
i14 361 20  6.72    8600    0.15
i15 362 20  8.92    8000    0.15
i10 363 20  8.94    8000    0.15
i11 364 20  9.57    8000    0.15
i12 366 20  8.43    8200    0.15
i13 366 20  10.35   8000    0.15
i14 369 20  6.22    8000    0.15
i15 370 20  9.62    9000    0.15
i10 372 20  7.51    8000    0.15
i11 372 20  10.65   8000    0.15
i12 375 20  4.95    8200    0.15
i7  377.000 11.548  9.53    7000    0.05
i7  378.548 11.582  9.54    7000    0.05
i7  380.130 11.748  9.57    7000    0.05
i7  381.878 12.083  9.63    7000    0.05
i7  383.961 11.986  9.69    7000    0.05
i7  385.947 11.675  9.71    7000    0.05
i7  387.622 11.524  9.72    7000    0.05
i13 378 20  6.58    8000    0.15
i14 379 20  8.54    8000    0.15
i15 380 20  9.35    8600    0.15
i10 382 20  8.77    8000    0.15
i11 383 20  9.93    8000    0.15
i12 385 20  7.52    8200    0.15
i13 385 20  10.75   8000    0.15
i14 386 20  4.62    8000    0.15
i7  390.000 13.353  15.45   7000    0.07
i7  393.353 13.183  15.43   7000    0.07
i7  396.536 12.854  15.37   7000    0.07
i7  399.390 12.866  15.31   7000    0.07
i7  402.256 13.192  15.28   7000    0.07
i7  405.448 13.361  15.28   7000    0.07
i7  408.809 11.450  15.28   7000    0.07
i15 391 20  5.48    9000    0.15
i10 393 20  6.30    8000    0.15
i11 394 20  8.29    8000    0.15
i12 394 20  9.48    8000    0.15
i13 396 20  8.43    8200    0.15
i14 396 20  10.32   8000    0.15
i15 399 20  6.31    8000    0.15
i10 400 20  9.76    8600    0.15
i11 402 20  7.21    8000    0.15
i12 402 20  10.58   8000    0.15
i13 405 20  5.12    8200    0.15
i14 408 20  7.10    8000    0.15
i15 408 20  9.11    8000    0.15
i10 409 20  8.75    9000    0.15
i11 410 20  9.88    8000    0.15
i12 412 20  7.65    8000    0.15
i13 412 20  10.75   8000    0.15
i14 415 20  4.65    8200    0.15
i7  417.000 10.466  9.40    7000    0.32
i7  417.466 10.806  9.46    7000    0.32
i7  418.272 10.633  9.51    7000    0.32
i7  418.905 10.330  9.53    7000    0.32
i7  419.234 12.153  9.53    7000    0.32
i7  421.387 11.975  9.51    7000    0.32
i7  423.362 11.670  9.46    7000    0.32
i15 418 20  5.59    8000    0.15
i10 420 20  6.59    8600    0.15
i11 421 20  8.76    8000    0.15
i12 422 20  9.12    8000    0.15
i13 423 20  9.24    8000    0.15
i14 424 20  9.14    8200    0.15
i15 425 20  9.36    8000    0.15
i10 427 20  8.93    8000    0.15
i11 428 20  9.71    9000    0.15
i12 430 20  8.11    8000    0.15
i13 430 20  10.61   8000    0.15
i14 433 20  5.30    8200    0.15
i15 436 20  7.60    8000    0.15
i10 436 20  9.37    8000    0.15
i11 438 20  8.44    8600    0.15
i12 438 20  10.28   8000    0.15
i13 441 20  6.43    8000    0.15
i14 442 20  9.93    8000    0.15
i15 444 20  6.82    8200    0.15
i10 445 20  10.32   8000    0.15
i11 448 20  5.83    9000    0.15
i12 450 20  8.85    8000    0.15
i13 451 20  8.76    8000    0.15
i14 452 20  9.79    8000    0.15
i15 454 20  7.87    8200    0.15
i10 454 20  10.71   8000    0.15
i11 455 20  4.87    8000    0.15
i7  457.000 12.075  13.26   7000    0.42
i7  459.075 12.279  13.25   7000    0.42
i7  463.354 12.382  13.25   7000    0.42
i7  465.736 10.483  13.26   7000    0.42
i7  466.219 10.679  13.29   7000    0.42
i7  466.897 11.021  13.35   7000    0.42
i7  467.918 10.890  13.40   7000    0.42
i12 460 20  6.34    8600    0.15
i13 461 20  8.17    8000    0.15
i14 462 20  9.56    8000    0.15
i15 463 20  8.21    8200    0.15
i10 463 20  10.50   8000    0.15
i11 466 20  5.66    8000    0.15
i12 468 20  8.52    9000    0.15
i13 469 20  9.09    8000    0.15
i14 470 20  9.22    8000    0.15
i15 471 20  9.18    8000    0.15
i10 472 20  9.28    8200    0.15
i11 473 20  9.08    8000    0.15
i12 474 20  9.46    8000    0.15
i13 476 20  8.71    8600    0.15
i14 477 20  10.04   8000    0.15
i15 479 20  7.22    8000    0.15
i10 479 20  10.67   8000    0.15
i11 482 20  4.82    8200    0.15
i7  484.000 11.373  9.78    7000    0.57
i7  485.373 13.197  9.76    7000    0.57
i7  488.570 12.895  9.72    7000    0.57
i7  491.465 12.703  9.65    7000    0.57
i7  494.168 13.046  9.62    7000    0.57
i7  497.214 13.253  9.61    7000    0.57
i7  500.467 13.352  9.61    7000    0.57
i12 485 20  6.16    8000    0.15
i13 486 20  7.84    9000    0.15
i14 486 20  9.62    8000    0.15
i15 486 20  7.98    8000    0.15
i10 488 20  10.63   8000    0.15
i11 491 20  5.17    8200    0.15
i12 494 20  7.26    8000    0.15
i13 494 20  9.23    8000    0.15
i14 495 20  8.60    8600    0.15
i15 496 20  10.08   8000    0.15
i10 498 20  7.06    8000    0.15
i11 498 20  10.58   8000    0.15
i12 501 20  5.08    8200    0.15
i13 504 20  6.97    8000    0.15
i14 504 20  9.01    8000    0.15
i15 505 20  8.88    9000    0.15
i10 506 20  9.67    8000    0.15
i11 508 20  8.18    8000    0.15
i12 508 20  10.56   8000    0.15
i13 512 20  5.49    8200    0.15
i14 513 20  8.11    8000    0.15
i15 513 20  9.34    8000    0.15
i10 515 20  8.65    8600    0.15
i11 516 20  10.06   8000    0.15
i12 518 20  7.13    8000    0.15
i13 518 20  10.62   8200    0.15
i14 521 20  4.95    8000    0.15
i7  523.000 10.343  9.26    7000    0.32
i7  523.343 10.665  9.32    7000    0.32
i7  524.007 10.738  9.38    7000    0.32
i7  524.745 10.398  9.41    7000    0.32
i7  525.143 10.232  9.42    7000    0.32
i7  525.375 10.189  9.23    7000    0.32
i7  525.564 10.226  9.24    7000    0.32
i15 524 20  6.57    9000    0.15
i10 525 20  8.53    8000    0.15
i11 526 20  9.36    8000    0.15
i12 528 20  8.74    8000    0.15
i13 529 20  9.97    8200    0.15
i14 531 20  7.41    8000    0.15
i15 531 20  10.73   8000    0.15
i10 534 20  4.65    8600    0.15
i7  536.000 10.916  9.95    7000    0.26
i7  536.916 10.894  10.00   7000    0.26
i7  537.810 10.565  10.03   7000    0.26
i7  538.375 10.412  10.04   7000    0.26
i7  538.787 10.361  9.84    7000    0.26
i7  539.148 10.363  9.85    7000    0.26
i7  539.510 10.418  9.86    7000    0.26
i11 537 20  5.58    8000    0.15
i12 539 20  6.57    8200    0.15
i13 540 20  8.72    8000    0.15
i14 541 20  9.15    8000    0.15
i15 542 20  9.18    8000    0.15
i10 543 20  9.25    9000    0.15
i11 544 20  9.14    8000    0.15
i12 545 20  9.36    8000    0.15
i13 547 20  8.92    8000    0.15
i14 548 20  9.73    8200    0.15
i15 550 20  8.05    8000    0.15
i10 550 20  10.64   8000    0.15
i11 553 20  5.17    8600    0.15
i12 556 20  7.24    8000    0.15
i13 556 20  9.22    8000    0.15
i14 557 20  8.62    8200    0.15
i15 558 20  10.06   8000    0.15
i10 560 20  7.12    8000    0.15
i11 560 20  10.61   8000    0.15
i12 563 20  4.98    9000    0.15
i7  565.000 10.931  9.95    7000    0.10
i7  565.931 10.890  10.01   7000    0.10
i7  566.820 10.561  10.04   7000    0.10
i7  567.381 10.399  10.04   7000    0.10
i7  567.781 12.318  10.04   7000    0.10
i7  570.098 12.232  10.03   7000    0.10
i7  572.331 12.057  10.01   7000    0.10
i13 566 20  6.66    8000    0.15
i14 567 20  8.66    8200    0.15
i15 568 20  9.25    8000    0.15
i10 569 20  8.98    8000    0.15
i11 570 20  9.61    8000    0.15
i12 571 20  8.36    8600    0.15
i13 572 20  10.41   8000    0.15
i14 575 20  6.00    8000    0.15
i15 577 20  9.23    8200    0.15
i10 578 20  8.23    8000    0.15
i11 578 20  10.40   8000    0.15
i12 581 20  6.02    9000    0.15
i13 583 20  9.25    8000    0.15
i14 584 20  8.19    8000    0.15
i15 584 20  10.43   8000    0.15
i10 587 20  5.90    8200    0.15
i11 589 20  9.03    8000    0.15
i12 590 20  8.53    8000    0.15
i13 591 20  10.10   8600    0.15
i14 594 20  6.98    8000    0.15
i15 594 20  10.52   8000    0.15
i10 597 20  5.25    8200    0.15
i11 600 20  7.44    8000    0.15
i12 600 20  9.32    8000    0.15
i13 602 20  8.48    9000    0.15
i14 602 20  10.23   8000    0.15
i15 605 20  6.61    8000    0.15
i10 606 20  10.16   8200    0.15
i11 609 20  6.24    8000    0.15
i12 610 20  9.60    8000    0.15
i13 612 20  7.56    8600    0.15
i14 612 20  10.66   8000    0.15
i15 615 20  4.95    8000    0.15
i7  617.000 12.157  13.42   7000    0.19
i7  619.157 12.490  13.40   7000    0.19
i7  621.646 12.663  13.39   7000    0.19
i7  624.310 10.779  13.40   7000    0.19
i7  625.089 10.951  13.42   7000    0.19
i7  626.040 11.282  13.47   7000    0.19
i7  627.322 11.334  13.54   7000    0.19
i10 618 20  6.59    8200    0.15
i11 619 20  8.56    8000    0.15
i12 620 20  9.34    8000    0.15
i13 622 20  8.79    9000    0.15
i14 623 20  9.90    8000    0.15
i15 624 20  7.61    8000    0.15
i10 625 20  10.75   8200    0.15
i11 628 20  4.63    8000    0.15
i7  630.000 11.466  10.03   7000    0.43
i7  631.466 11.383  10.03   7000    0.43
i7  632.849 13.309  10.03   7000    0.43
i7  636.158 13.166  10.01   7000    0.43
i7  639.324 12.858  9.96    7000    0.43
i7  642.182 12.706  9.89    7000    0.43
i7  644.888 13.056  9.86    7000    0.43
i12 629 20  5.51    8600    0.15
i13 633 20  6.39    8000    0.15
i14 634 20  8.45    8000    0.15
i15 634 20  9.38    8000    0.15
i10 636 20  8.67    8200    0.15
i11 637 20  10.05   8000    0.15
i12 639 20  7.17    8000    0.15
i13 639 20  10.64   8000    0.15
i14 642 20  4.89    9000    0.15
i7  644.000 11.852  14.99   7000    0.18
i7  645.852 11.694  14.96   7000    0.18
i7  647.546 11.345  14.89   7000    0.18
i7  648.891 11.467  14.84   7000    0.18
i7  650.358 11.782  14.82   7000    0.18
i7  652.140 11.925  14.81   7000    0.18
i7  654.064 11.986  14.81   7000    0.18
i15 645 20  6.39    8000    0.15
i10 646 20  8.25    8200    0.15
i11 646 20  9.53    8000    0.15
i12 648 20  8.32    8000    0.15
i13 648 20  10.42   8000    0.15
i14 651 20  5.96    8600    0.15
i15 654 20  9.14    8000    0.15
i10 654 20  8.36    8000    0.15
i11 654 20  10.28   8200    0.15
i12 657 20  6.42    8000    0.15
i13 658 20  9.92    8000    0.15
i14 660 20  6.84    9000    0.15
i15 661 20  10.34   8000    0.15
i10 664 20  5.79    8000    0.15
i11 666 20  8.76    8200    0.15
i12 667 20  8.87    8000    0.15
i13 668 20  9.62    8000    0.15
i14 670 20  8.31    8600    0.15
i15 670 20  10.46   8000    0.15
i10 673 20  5.85    8000    0.15
i11 675 20  8.92    8200    0.15
i12 676 20  8.67    8000    0.15
i13 677 20  9.91    8000    0.15
i14 679 20  7.53    9000    0.15
i15 679 20  10.75   8000    0.15
i10 682 20  4.63    8000    0.15
i7  684.000 10.153  9.10    7000    0.05
i7  684.153 10.333  9.13    7000    0.05
i7  684.485 10.683  9.20    7000    0.05
i7  685.168 10.590  9.25    7000    0.05
i7  685.759 10.263  9.27    7000    0.05
i7  686.021 10.088  9.27    7000    0.05
i7  686.110 11.952  9.26    7000    0.05
i11 685 20  5.52    8200    0.15
i12 687 20  6.41    8000    0.15
i13 688 20  8.47    8000    0.15
i14 688 20  9.37    8000    0.15
i15 690 20  8.71    8600    0.15
i10 691 20  10.00   8000    0.15
i11 693 20  7.32    8000    0.15
i12 693 20  10.70   8200    0.15
i13 696 20  4.72    8000    0.15
i7  698.000 12.405  14.33   7000    0.41
i7  700.405 12.643  14.28   7000    0.41
i7  703.048 12.945  14.27   7000    0.41
i7  705.993 11.141  14.27   7000    0.41
i7  707.134 11.387  14.30   7000    0.41
i7  708.521 11.738  14.37   7000    0.41
i7  710.259 11.530  14.41   7000    0.41
i14 699 20  5.82    9000    0.15
i15 701 20  7.15    8000    0.15
i10 701 20  9.36    8000    0.15
i11 703 20  8.32    8000    0.15
i12 703 20  10.37   8200    0.15
i13 706 20  6.13    8000    0.15
i14 707 20  9.45    8000    0.15
i15 709 20  7.83    8600    0.15
i10 709 20  10.62   8000    0.15
i11 712 20  5.18    8000    0.15
i12 715 20  7.26    8200    0.15
i13 715 20  9.23    8000    0.15
i14 716 20  8.60    8000    0.15
i15 717 20  10.09   8000    0.15
i10 718 20  7.04    9000    0.15
i11 719 20  10.56   8000    0.15
i12 721 20  5.12    8000    0.15
i13 725 20  7.06    8200    0.15
i14 725 20  9.09    8000    0.15
i15 726 20  8.79    8000    0.15
i10 727 20  9.83    8600    0.15
i11 729 20  7.79    8000    0.15
i12 729 20  10.73   8000    0.15
i13 732 20  4.76    8200    0.15
i7  734.000 13.218  9.56    7000    0.78
i7  737.218 12.905  9.52    7000    0.78
i7  740.123 12.663  9.45    7000    0.78
i7  742.786 13.010  9.42    7000    0.78
i7  745.796 13.267  9.41    7000    0.78
i7  749.063 11.471  9.43    7000    0.78
i7  750.534 11.783  9.47    7000    0.78
i14 735 20  5.96    8000    0.15
i15 737 20  7.44    8000    0.15
i10 737 20  9.54    9000    0.15
i11 739 20  8.05    8000    0.15
i12 739 20  10.58   8000    0.15
i13 742 20  5.37    8200    0.15
i14 744 20  7.80    8000    0.15
i15 744 20  9.40    8000    0.15
i10 746 20  8.45    8000    0.15
i11 748 20  10.28   8600    0.15
i12 748 20  6.45    8000    0.15
i13 750 20  9.96    8000    0.15
i14 752 20  6.75    8200    0.15
i15 753 20  10.25   8000    0.15
i10 756 20  6.02    8000    0.15
i11 758 20  9.22    9000    0.15
i12 759 20  8.25    8000    0.15
i13 759 20  10.38   8000    0.15
i14 762 20  6.08    8200    0.15
i15 764 20  9.38    8000    0.15
i10 766 20  7.97    8000    0.15
i11 766 20  10.56   8600    0.15
i7  766 20.000  11.56   7000    0.00
i6  766 30  9.56    9000    10  0.5
e
</CsScore>
</CsoundSynthesizer>
